<?php

/**
 * Provide a admin-facing view for the General Settings Fields form of the plugin
 *
 * This file is used to markup the admin-facing settings form of the plugin admin side.
 *
 * @link       https://staggs.app
 * @since      1.5.0
 *
 * @package    Staggs
 * @subpackage Staggs/admin/fields
 */

if ( ! function_exists( 'acf_add_local_field_group' ) ) {
	return;
}

$setting_fields = array(
	array(
		'key' => 'field_64ce5cf75549c',
		'label' => 'Brand',
		'name' => '',
		'aria-label' => '',
		'type' => 'tab',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'placement' => 'left',
		'endpoint' => 0,
	),
	array(
		'key' => 'field_64ce5db35549d',
		'label' => '',
		'name' => '',
		'aria-label' => '',
		'type' => 'message',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '<h3>Brand</h3>',
		'new_lines' => 'wpautop',
		'esc_html' => 0,
	),
	array(
		'key' => 'field_64ce5e11554a1',
		'label' => 'Company logo',
		'name' => 'sgg_logo',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => 'Note: please keep image sizes lower than 2 MB to maintain the configurator performance.',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => '',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64ce5e29554a2',
		'label' => 'Company name',
		'name' => 'sgg_company_name',
		'aria-label' => '',
		'type' => 'text',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'default_value' => '',
		'maxlength' => '',
		'placeholder' => '',
		'prepend' => '',
		'append' => '',
	),
	array(
		'key' => 'field_64ce5e3b554a3',
		'label' => 'Font family',
		'name' => 'sgg_font_family',
		'aria-label' => '',
		'type' => 'text',
		'instructions' => 'If you need a custom font, you should enter the font family name here (e.g. Helvetica).',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '33',
			'class' => '',
			'id' => '',
		),
		'default_value' => '',
		'maxlength' => '',
		'placeholder' => '',
		'prepend' => '',
		'append' => '',
	),
	array(
		'key' => 'field_64ce5e3b559b3',
		'label' => 'Font Weight',
		'name' => 'sgg_font_weight',
		'aria-label' => '',
		'type' => 'text',
		'instructions' => 'Enter the font weight here. Use CSS units (e.g. 700 or bold).',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '33',
			'class' => '',
			'id' => '',
		),
		'default_value' => '',
		'maxlength' => '',
		'placeholder' => '',
		'prepend' => '',
		'append' => '',
	),
	array(
		'key' => 'field_64ce5e3b559b5',
		'label' => 'Font Style',
		'name' => 'sgg_font_style',
		'aria-label' => '',
		'type' => 'select',
		'instructions' => 'Select the font style here.',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '33',
			'class' => '',
			'id' => '',
		),
		'choices' => array(
			'normal' => 'Normal',
			'italic' => 'Italic',
		),
		'default_value' => false,
		'return_format' => 'value',
		'multiple' => 0,
		'allow_null' => 0,
		'ui' => 0,
		'ajax' => 0,
		'placeholder' => '',
	),
	array(
		'key' => 'field_64ce5e4e554a4',
		'label' => 'Footer Scripts',
		'name' => 'sgg_footer_scripts',
		'aria-label' => '',
		'type' => 'textarea',
		'instructions' => 'If you need to add scripts to your footer (like Google Fonts), you should enter them here.',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => 'editor-css',
			'id' => '',
		),
		'default_value' => '',
		'maxlength' => '',
		'rows' => 12,
		'placeholder' => '',
		'new_lines' => '',
	),
	array(
		'key' => 'field_64ce5ebf554a9',
		'label' => 'Labels',
		'name' => '',
		'aria-label' => '',
		'type' => 'tab',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'placement' => 'left',
		'endpoint' => 0,
	),
	array(
		'key' => 'field_64ce5ebf554b1',
		'label' => '',
		'name' => '',
		'aria-label' => '',
		'type' => 'message',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '<h3>Labels</h3>',
		'new_lines' => 'wpautop',
		'esc_html' => 0,
	),
	array(
		'key' => 'field_64ce5e3b554b1',
		'label' => 'Fullscreen button label',
		'name' => 'sgg_gallery_fullscreen_label',
		'aria-label' => '',
		'type' => 'text',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '50',
			'class' => '',
			'id' => '',
		),
		'default_value' => '',
		'maxlength' => '',
		'placeholder' => 'Toggle fullscreen mode',
		'prepend' => '',
		'append' => '',
	),
	array(
		'key' => 'field_64ce5e3b554b2',
		'label' => 'Camera button label',
		'name' => 'sgg_gallery_camera_label',
		'aria-label' => '',
		'type' => 'text',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '50',
			'class' => '',
			'id' => '',
		),
		'default_value' => '',
		'maxlength' => '',
		'placeholder' => 'Capture configuration image',
		'prepend' => '',
		'append' => '',
	),
	array(
		'key' => 'field_64ce5e3b552c6',
		'label' => 'Reset button label',
		'name' => 'sgg_gallery_reset_label',
		'aria-label' => '',
		'type' => 'text',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'default_value' => '',
		'maxlength' => '',
		'placeholder' => 'Reset configuration',
		'prepend' => '',
		'append' => '',
	),
	array(
		'key' => 'field_64ce5e3b554b7',
		'label' => 'Product total label',
		'name' => 'sgg_configurator_summary_table_title',
		'aria-label' => '',
		'type' => 'text',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '50',
			'class' => '',
			'id' => '',
		),
		'default_value' => '',
		'maxlength' => '',
		'placeholder' => 'Your configuration',
		'prepend' => '',
		'append' => '',
	),
	array(
		'key' => 'field_64ce5e3b554d6',
		'label' => 'Required configuration error message',
		'name' => 'sgg_product_required_error_message',
		'aria-label' => '',
		'type' => 'text',
		'instructions' => 'Optionally override required error message.',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '50',
			'class' => '',
			'id' => '',
		),
		'default_value' => '',
		'maxlength' => '',
		'placeholder' => 'Please fill out all required fields!',
		'prepend' => '',
		'append' => '',
	),
	array(
		'key' => 'field_64ce5e3b554d7',
		'label' => 'Invalid configuration error message',
		'name' => 'sgg_product_invalid_error_message',
		'aria-label' => '',
		'type' => 'text',
		'instructions' => 'Optionally override invalid error message.',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '50',
			'class' => '',
			'id' => '',
		),
		'default_value' => '',
		'maxlength' => '',
		'placeholder' => 'Please make sure all fields are filled out correctly!',
		'prepend' => '',
		'append' => '',
	),
	array(
		'key' => 'field_64ce5e3b553d8',
		'label' => 'Required configuration field message',
		'name' => 'sgg_product_required_field_message',
		'aria-label' => '',
		'type' => 'text',
		'instructions' => 'Optionally override required field message.',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '50',
			'class' => '',
			'id' => '',
		),
		'default_value' => '',
		'maxlength' => '',
		'placeholder' => 'This field is required.',
		'prepend' => '',
		'append' => '',
	),
	array(
		'key' => 'field_64ce5e3b553d9',
		'label' => 'Invalid configuration field message',
		'name' => 'sgg_product_invalid_field_message',
		'aria-label' => '',
		'type' => 'text',
		'instructions' => 'Optionally override invalid field message.',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '50',
			'class' => '',
			'id' => '',
		),
		'default_value' => '',
		'maxlength' => '',
		'placeholder' => 'This field is invalid.',
		'prepend' => '',
		'append' => '',
	),
	array(
		'key' => 'field_64ce5ebf554a5',
		'label' => 'Icons',
		'name' => '',
		'aria-label' => '',
		'type' => 'tab',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'placement' => 'left',
		'endpoint' => 0,
	),
	array(
		'key' => 'field_64ce5ebf554a6',
		'label' => '',
		'name' => '',
		'aria-label' => '',
		'type' => 'message',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '<h3>Icons</h3>',
		'new_lines' => 'wpautop',
		'esc_html' => 0,
	),
	array(
		'key' => 'field_64ce5ec8554a6',
		'label' => 'Gallery arrow left',
		'name' => 'sgg_slider_arrow_left',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64ce5f02554a7',
		'label' => 'Gallery arrow left (dark theme)',
		'name' => 'sgg_slider_arrow_dark',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64ce5f0c554a8',
		'label' => 'Gallery arrow right',
		'name' => 'sgg_slider_arrow_right',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64ce5f17554a9',
		'label' => 'Gallery arrow right (dark theme)',
		'name' => 'sgg_slider_arrow_right_dark',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64ce5f23554aa',
		'label' => 'Select arrow',
		'name' => 'sgg_select_arrow',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64ce5f2d554ab',
		'label' => 'Select arrow (dark theme)',
		'name' => 'sgg_select_arrow_dark',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64ce5f3a554ac',
		'label' => 'Checkmark icon',
		'name' => 'sgg_checkmark',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64ce5f43554ad',
		'label' => 'Checkmark icon (dark theme)',
		'name' => 'sgg_checkmark_dark',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64ce5f58554b0',
		'label' => 'Panel Close icon',
		'name' => 'sgg_group_close_icon',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64ce5f5e554b1',
		'label' => 'Panel Close icon (dark theme)',
		'name' => 'sgg_group_close_icon_dark',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64ce5f58554b2',
		'label' => 'Close icon',
		'name' => 'sgg_close_icon',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64ce5f5e554b3',
		'label' => 'Close icon (dark theme)',
		'name' => 'sgg_close_icon_dark',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64ce5f66554b2',
		'label' => 'Description plus icon',
		'name' => 'sgg_group_plus_icon',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64ce5f71554b3',
		'label' => 'Description plus icon (dark theme)',
		'name' => 'sgg_group_plus_icon_dark',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64ce5f77554b4',
		'label' => 'Description minus icon',
		'name' => 'sgg_group_minus_icon',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64ce5f99554b5',
		'label' => 'Description minus icon (dark theme)',
		'name' => 'sgg_group_minus_icon_dark',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64ce5f4a554ae',
		'label' => 'Info icon',
		'name' => 'sgg_group_info_icon',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64ce5f50554af',
		'label' => 'Info icon (dark theme)',
		'name' => 'sgg_group_info_icon_dark',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64ce5fba554ba',
		'label' => 'Popup back icon',
		'name' => 'sgg_popup_back_icon',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64ce5fc3554bb',
		'label' => 'Popup back icon (dark theme)',
		'name' => 'sgg_popup_back_icon_dark',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64ce5fc9554bc',
		'label' => 'Separator collapse icon',
		'name' => 'sgg_separator_collapse_icon',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64ce5fd9554bd',
		'label' => 'Separator collapse icon (dark theme)',
		'name' => 'sgg_separator_collapse_icon_dark',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64ce5fd9556b1',
		'label' => 'Fullscreen icon',
		'name' => 'sgg_fullscreen_icon',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64ce5fd9556b2',
		'label' => 'Fullscreen icon (dark theme)',
		'name' => 'sgg_fullscreen_icon_dark',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64ce5fd9556b3',
		'label' => 'Fullscreen close icon',
		'name' => 'sgg_fullscreen_close_icon',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64ce5fd9556b4',
		'label' => 'Fullscreen close icon (dark theme)',
		'name' => 'sgg_fullscreen_close_icon_dark',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64e0efd8f8c63',
		'label' => 'Calendar icon',
		'name' => 'sgg_calendar_icon',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64e0efebf8c64',
		'label' => 'Calendar icon (dark theme)',
		'name' => 'sgg_calendar_icon_dark',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64e0effd8f8c65',
		'label' => 'Image zoom icon',
		'name' => 'sgg_zoom_icon',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64e0efebf8c66',
		'label' => 'Image zoom icon (dark theme)',
		'name' => 'sgg_zoom_icon_dark',
		'aria-label' => '',
		'type' => 'image',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '25',
			'class' => '',
			'id' => '',
		),
		'return_format' => 'id',
		'library' => 'all',
		'min_width' => '',
		'min_height' => '',
		'min_size' => '',
		'max_width' => '',
		'max_height' => '',
		'max_size' => '',
		'mime_types' => 'jpg, jpeg, png, svg, webp, eps, gif, tiff',
		'preview_size' => 'thumbnail',
	),
	array(
		'key' => 'field_64d769fde84b3',
		'label' => 'Attributes',
		'name' => '',
		'aria-label' => '',
		'type' => 'tab',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'placement' => 'left',
		'endpoint' => 0,
	),
	array(
		'key' => 'field_64d769fde84b6',
		'label' => '',
		'name' => '',
		'aria-label' => '',
		'type' => 'message',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '<h3>Attributes</h3>',
		'new_lines' => 'wpautop',
		'esc_html' => 0,
	),
	array(
		'key' => 'field_64d76d08206b0',
		'label' => 'Disable dropdown placeholders',
		'name' => 'sgg_product_dropdown_disable_placeholder',
		'aria-label' => '',
		'type' => 'true_false',
		'instructions' => 'Disable dropdown placeholders for non-required dropdowns.',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '',
		'default_value' => 0,
		'ui_on_text' => '',
		'ui_off_text' => '',
		'ui' => 1,
	),
	array(
		'key' => 'field_64d76d08206c0',
		'label' => 'Disable mobile native dropdown UI',
		'name' => 'sgg_product_dropdown_disable_mobile_ui',
		'aria-label' => '',
		'type' => 'true_false',
		'instructions' => 'Displays dropdowns in same style as on desktop devices.',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '',
		'default_value' => 0,
		'ui_on_text' => '',
		'ui_off_text' => '',
		'ui' => 1,
	),
	array(
		'key' => 'field_64d76d08206a5',
		'label' => 'Disable click for URL options',
		'name' => 'sgg_product_url_option_disable_click',
		'aria-label' => '',
		'type' => 'true_false',
		'instructions' => 'Removes the default click handler for URL options so you can handle the link your own way.',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '',
		'default_value' => 0,
		'ui_on_text' => '',
		'ui_off_text' => '',
		'ui' => 1,
	),
	array(
		'key' => 'field_64d76d08206b7',
		'label' => 'Included Option Price label',
		'name' => 'sgg_step_included_text',
		'aria-label' => '',
		'type' => 'text',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'default_value' => '',
		'maxlength' => '',
		'placeholder' => '',
		'prepend' => '',
		'append' => '',
	),
	array(
		'key' => 'field_64d76d08206a3',
		'label' => 'Show sign for additional prices',
		'name' => 'sgg_product_additional_price_sign',
		'aria-label' => '',
		'type' => 'true_false',
		'instructions' => 'Displays a plus sign before the option price to indicate additional charges (+$99).',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '',
		'default_value' => 0,
		'ui_on_text' => '',
		'ui_off_text' => '',
		'ui' => 1,
	),
	array(
		'key' => 'field_64d76d08206b3',
		'label' => 'Trim price decimals on full prices',
		'name' => 'sgg_product_price_trim_decimals',
		'aria-label' => '',
		'type' => 'true_false',
		'instructions' => 'Display prices that ends on ",00" in a format of ",-".',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '50',
			'class' => '',
			'id' => '',
		),
		'message' => '',
		'default_value' => 0,
		'ui_on_text' => '',
		'ui_off_text' => '',
		'ui' => 1,
	),
	array(
		'key' => 'field_64d76d08217b7',
		'label' => 'Show price difference only for option prices',
		'name' => 'sgg_product_price_show_difference_only',
		'aria-label' => '',
		'type' => 'true_false',
		'instructions' => 'Dynamically update difference in price options based on current selected option.',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '',
		'default_value' => 0,
		'ui_on_text' => '',
		'ui_off_text' => '',
		'ui' => 1,
	),
	array(
		'key' => 'field_64d76d08217b8',
		'label' => 'Base unit price calculations on minimum value',
		'name' => 'sgg_product_price_unit_min_based',
		'aria-label' => '',
		'type' => 'true_false',
		'instructions' => 'Perceive minimum input value as 0 for unit price calculations.',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '',
		'default_value' => 0,
		'ui_on_text' => '',
		'ui_off_text' => '',
		'ui' => 1,
	),
	array(
		'key' => 'field_64d76d08206b9',
		'label' => 'Display individual error messages for each attribute',
		'name' => 'sgg_product_show_individual_error_messages',
		'aria-label' => '',
		'type' => 'true_false',
		'instructions' => 'Adds error messages to all invalid fields instead of one general alert',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '',
		'default_value' => 0,
		'ui_on_text' => '',
		'ui_off_text' => '',
		'ui' => 1,
	),
	array(
		'key' => 'field_64d76d08217b9',
		'label' => 'Hide duplicate attribute titles in summary widget',
		'name' => 'sgg_product_summary_hide_duplicate_titles',
		'aria-label' => '',
		'type' => 'true_false',
		'instructions' => 'If multi select is active, show attribute title for first option only.',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '',
		'default_value' => 0,
		'ui_on_text' => '',
		'ui_off_text' => '',
		'ui' => 1,
	),
	array(
		'key' => 'field_64d76d08564d4',
		'label' => 'Include button controls in number inputs',
		'name' => 'sgg_product_number_input_show_icons',
		'aria-label' => '',
		'type' => 'true_false',
		'instructions' => 'Shows plus and minus button icons for number input fields.',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '',
		'default_value' => 0,
		'ui_on_text' => '',
		'ui_off_text' => '',
		'ui' => 1,
	),
	array(
		'key' => 'field_64d769fde84b4',
		'label' => 'WooCommerce',
		'name' => '',
		'aria-label' => '',
		'type' => 'tab',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'placement' => 'left',
		'endpoint' => 0,
	),
	array(
		'key' => 'field_64d769fec84b5',
		'label' => '',
		'name' => '',
		'aria-label' => '',
		'type' => 'message',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '<h3>WooCommerce</h3>',
		'new_lines' => 'wpautop',
		'esc_html' => 0,
	),
	array(
		'key' => 'field_64d76d08206a2',
		'label' => 'Price prefix',
		'name' => 'sgg_product_prefix_label',
		'aria-label' => '',
		'type' => 'text',
		'instructions' => 'Optionally display price prefix label on archives. E.g. From:',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '50',
			'class' => '',
			'id' => '',
		),
		'default_value' => '',
		'maxlength' => '',
		'placeholder' => '',
		'prepend' => '',
		'append' => '',
	),
	array(
		'key' => 'field_64d76d08206b6',
		'label' => 'Configurator loop add to cart button label',
		'name' => 'sgg_product_loop_cart_label',
		'aria-label' => '',
		'type' => 'text',
		'instructions' => 'Optionally override add to cart text display on archives.',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '50',
			'class' => '',
			'id' => '',
		),
		'default_value' => '',
		'maxlength' => '',
		'placeholder' => '',
		'prepend' => '',
		'append' => '',
	),
	array(
		'key' => 'field_64d76d08206b5',
		'label' => 'Price format',
		'name' => 'sgg_product_price_format',
		'aria-label' => '',
		'type' => 'text',
		'instructions' => 'Optionally override price display on archives. E.g. {min_price} - {max_price}. Available placeholders: {price}, {sale_price}, {min_price}, {max_price}',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'default_value' => '',
		'maxlength' => '',
		'placeholder' => '',
		'prepend' => '',
		'append' => '',
	),
	array(
		'key' => 'field_64d76d08206a4',
		'label' => 'Exclude product base price in totals',
		'name' => 'sgg_product_exclude_base_price',
		'aria-label' => '',
		'type' => 'true_false',
		'instructions' => 'Exclude WooCommerce product price from total price calculation.',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '',
		'default_value' => 0,
		'ui_on_text' => '',
		'ui_off_text' => '',
		'ui' => 1,
	),
	array(
		'key' => 'field_64d76d08289b5',
		'label' => 'Show prices for logged in users only',
		'name' => 'sgg_product_show_price_logged_in_users',
		'aria-label' => '',
		'type' => 'true_false',
		'instructions' => 'Hide pricings for website visitors. Show prices to logged in customers.',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '',
		'default_value' => 0,
		'ui_on_text' => '',
		'ui_off_text' => '',
		'ui' => 1,
	),
	array(
		'key' => 'field_64d76d08289b6',
		'label' => 'Redirect visitors to login page',
		'name' => 'sgg_product_redirect_visitors_to_login_page',
		'aria-label' => '',
		'type' => 'true_false',
		'instructions' => 'Redirects visitors to the login page when clicking the main configuration button.',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '',
		'default_value' => 0,
		'ui_on_text' => '',
		'ui_off_text' => '',
		'ui' => 1,
	),
	array(
		'key' => 'field_64d76d082061d',
		'label' => 'Price tax suffix',
		'name' => 'sgg_product_tax_label',
		'aria-label' => '',
		'type' => 'text',
		'instructions' => 'Optionally display price tax suffix in configurator totals.',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'default_value' => '',
		'maxlength' => '',
		'placeholder' => 'Inc. VAT',
		'prepend' => '',
		'append' => '',
	),
	array(
		'key' => 'field_64ce61a156eb1',
		'label' => 'Checkout',
		'name' => '',
		'aria-label' => '',
		'type' => 'tab',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'placement' => 'left',
		'endpoint' => 0,
	),
	array(
		'key' => 'field_64ce61a156ef3',
		'label' => 'Price settings',
		'name' => '',
		'aria-label' => '',
		'type' => 'tab',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'placement' => 'left',
		'endpoint' => 0,
	),
	array(
		'key' => 'field_64ce61a156cf4',
		'label' => '',
		'name' => '',
		'aria-label' => '',
		'type' => 'message',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '<h3>Price settings</h3>',
		'new_lines' => 'wpautop',
		'esc_html' => 0,
	),
);

if ( ! is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
	array_merge( 
		$setting_fields, 
		array(
			'key' => 'field_64ce61a156ef4',
			'label' => 'Currency position',
			'name' => 'sgg_price_currency_pos',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Select the position of the currency symbol',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '20',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'left_space' => 'Left with a space',
				'left' => 'Left',
				'right_space' => 'Right with a space',
				'right' => 'Right',
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64ce61a156ef5',
			'label' => 'Currency symbol',
			'name' => 'sgg_price_currency_symbol',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Optionally enter your currency symbol',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '80',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce61a156ef6',
			'label' => 'Thousand separator',
			'name' => 'sgg_price_thousand_sep',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce61a156ef7',
			'label' => 'Decimal separator',
			'name' => 'sgg_price_decimal_sep',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce61a156ef8',
			'label' => 'Number of decimals',
			'name' => 'sgg_price_decimal_number',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '2',
			'prepend' => '',
			'append' => '',
		),
	);
} else {
	array_merge( 
		$setting_fields,
		array(
			'key' => 'field_64ce61a156cf5',
			'label' => '',
			'name' => '',
			'aria-label' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '<p>Configure price settings in WooCommerce -> Settings -> Currency options</p>',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
	);
}

array_merge( 
	$setting_fields,
	array(
		'key' => 'field_64ce61a156eb2',
		'label' => 'Checkout',
		'name' => '',
		'aria-label' => '',
		'type' => 'tab',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'placement' => 'left',
		'endpoint' => 0,
	),
	array(
		'key' => 'field_64ce61a156eb3',
		'label' => '',
		'name' => '',
		'aria-label' => '',
		'type' => 'message',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '<h3>Checkout</h3>',
		'new_lines' => 'wpautop',
		'esc_html' => 0,
	),
	array(
		'key' => 'field_64d76a0be84b1',
		'label' => 'Save attribute option prices to order items',
		'name' => 'sgg_order_save_attribute_prices',
		'aria-label' => '',
		'type' => 'true_false',
		'instructions' => 'Saves the individual option prices to the attributes in the order item for later reference.',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '',
		'default_value' => 0,
		'ui_on_text' => '',
		'ui_off_text' => '',
		'ui' => 1,
	),
	array(
		'key' => 'field_64d76d2720620',
		'label' => 'Product image width',
		'name' => 'sgg_checkout_image_width',
		'aria-label' => '',
		'type' => 'number',
		'instructions' => 'Enter the width value of the preview image in pixels (px).',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '50',
			'class' => '',
			'id' => '',
		),
		'default_value' => 70,
		'min' => '',
		'max' => '',
		'placeholder' => '',
		'step' => '',
		'prepend' => '',
		'append' => 'px',
	),
	array(
		'key' => 'field_64d76d5520621',
		'label' => 'Product image height',
		'name' => 'sgg_checkout_image_height',
		'aria-label' => '',
		'type' => 'number',
		'instructions' => 'Enter the height value of the preview image in pixels (px).',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '50',
			'class' => '',
			'id' => '',
		),
		'default_value' => 70,
		'min' => '',
		'max' => '',
		'placeholder' => '',
		'step' => '',
		'prepend' => '',
		'append' => 'px',
	),
	array(
		'key' => 'field_64d76a0be84b5',
		'label' => 'Display generated product image on checkout page',
		'name' => 'sgg_checkout_display_image',
		'aria-label' => '',
		'type' => 'true_false',
		'instructions' => 'Displays product image in table on checkout page when enabled. Applies to all products.',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '',
		'default_value' => 0,
		'ui_on_text' => '',
		'ui_off_text' => '',
		'ui' => 1,
	),
	array(
		'key' => 'field_64d76a52e84b6',
		'label' => 'Display generated product image on order pages',
		'name' => 'sgg_view_order_display_image',
		'aria-label' => '',
		'type' => 'true_false',
		'instructions' => 'Displays product image in tables on order pages when enabled. Applies to all products.',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '',
		'default_value' => 0,
		'ui_on_text' => '',
		'ui_off_text' => '',
		'ui' => 1,
	),
	array(
		'key' => 'field_64d76a6ae84b7',
		'label' => 'Display generated product image in order emails',
		'name' => 'sgg_confirmation_email_display_image',
		'aria-label' => '',
		'type' => 'true_false',
		'instructions' => 'Displays product image in WooCommerce order emails when enabled. Applies to all products.',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '',
		'default_value' => 0,
		'ui_on_text' => '',
		'ui_off_text' => '',
		'ui' => 1,
	),
	array(
		'key' => 'field_64ce61a156ee2',
		'label' => 'Advanced',
		'name' => '',
		'aria-label' => '',
		'type' => 'tab',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'placement' => 'left',
		'endpoint' => 0,
	),
	array(
		'key' => 'field_64ce61a156ee3',
		'label' => '',
		'name' => '',
		'aria-label' => '',
		'type' => 'message',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '<h3>Advanced</h3>',
		'new_lines' => 'wpautop',
		'esc_html' => 0,
	),
	array(
		'key' => 'field_64ce61ac91ad1',
		'label' => 'Image capture scale',
		'name' => 'sgg_desktop_image_capture_scale',
		'aria-label' => '',
		'type' => 'text',
		'instructions' => 'Image capture scale on desktop. Defaults to 1 (displayed image size).',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '33',
			'class' => '',
			'id' => '',
		),
		'default_value' => '',
		'maxlength' => '',
		'placeholder' => '',
		'prepend' => '',
		'append' => '',
	),
	array(
		'key' => 'field_64ce61ac91ad2',
		'label' => 'Image capture scale (tablet)',
		'name' => 'sgg_tablet_image_capture_scale',
		'aria-label' => '',
		'type' => 'text',
		'instructions' => 'Image capture scale on tablet. Defaults to 1.5 (displayed image size * 1.5).',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '33',
			'class' => '',
			'id' => '',
		),
		'default_value' => '',
		'maxlength' => '',
		'placeholder' => '',
		'prepend' => '',
		'append' => '',
	),
	array(
		'key' => 'field_64ce61ac91ad3',
		'label' => 'Image capture scale (mobile)',
		'name' => 'sgg_mobile_image_capture_scale',
		'aria-label' => '',
		'type' => 'text',
		'instructions' => 'Image capture scale on mobile. Defaults to 2 (displayed image size * 2).',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '33',
			'class' => '',
			'id' => '',
		),
		'default_value' => '',
		'maxlength' => '',
		'placeholder' => '',
		'prepend' => '',
		'append' => '',
	),
	array(
		'key' => 'field_64ce61ac56ea0',
		'label' => 'Enable inline edit links in attribute titles',
		'name' => 'sgg_admin_display_edit_links',
		'aria-label' => '',
		'type' => 'true_false',
		'instructions' => 'Display edit links in attribute title in configurator for site administrators to edit attributes quickly.',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '',
		'default_value' => 0,
		'ui_on_text' => '',
		'ui_off_text' => '',
		'ui' => 1,
	),
	array(
		'key' => 'field_64ce61ac56ea1',
		'label' => 'Enable Select2 library for improved attribute searches',
		'name' => 'sgg_admin_enable_select_two',
		'aria-label' => '',
		'type' => 'true_false',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '',
		'default_value' => 0,
		'ui_on_text' => '',
		'ui_off_text' => '',
		'ui' => 1,
	),
	array(
		'key' => 'field_64ce61f856ee4',
		'label' => 'Analytics Order statusses',
		'name' => 'sgg_analytics_order_statusses',
		'aria-label' => '',
		'type' => 'checkbox',
		'instructions' => 'Define the order statusses that analytics should display.',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'choices' => array(),
		'default_value' => array(
		),
		'return_format' => 'value',
		'allow_custom' => 0,
		'layout' => 'vertical',
		'toggle' => 0,
		'save_custom' => 0,
		'custom_choice_button_text' => 'Add new choice',
	),
	array(
		'key' => 'field_64ce623c56ee3',
		'label' => 'Custom CSS',
		'name' => '',
		'aria-label' => '',
		'type' => 'tab',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'placement' => 'left',
		'endpoint' => 0,
	),
	array(
		'key' => 'field_64ce623c56ee4',
		'label' => '',
		'name' => '',
		'aria-label' => '',
		'type' => 'message',
		'instructions' => '',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => '<h3>Custom CSS</h3>',
		'new_lines' => 'wpautop',
		'esc_html' => 0,
	),
	array(
		'key' => 'field_64ce623c56ee5',
		'label' => 'Custom CSS',
		'name' => 'sgg_custom_css',
		'aria-label' => '',
		'type' => 'textarea',
		'instructions' => 'If you need to add custom styling, you should enter the CSS here.',
		'required' => 0,
		'conditional_logic' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => 'editor-css',
			'id' => '',
		),
		'default_value' => '',
		'maxlength' => '',
		'rows' => 20,
		'placeholder' => '',
		'new_lines' => '',
	),
);

acf_add_local_field_group( array(
	'key' => 'group_64ce5cf6dbdaa',
	'title' => 'Staggs Settings',
	'fields' => $setting_fields,
	'location' => array(
		array(
			array(
				'param' => 'options_page',
				'operator' => '==',
				'value' => 'acf-options-settings',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'field',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );
